;     GUITAR TO MIDI CONVERTER 


	LIST P=16F88,   R=DEC        
	#INCLUDE "P16F88.INC"  

	__CONFIG _CONFIG1, H'2F10'		;INTERNAL OSC, I/O ON USUAL CLOCK PINS

#DEFINE PAGE0 bcf STATUS,5
#DEFINE PAGE1 bsf STATUS,5


DELAY3		EQU	22H
DELAY1	 	EQU 23H
DELAY2	 	EQU 24H
MIDLINE		EQU	25H
NOTE		EQU	26H
OCTAVE 		EQU	27H
LOBYTE		EQU	28H
HIBYTE		EQU	29H
VELOCITY	EQU	2AH
NEW			EQU	2BH
OLD			EQU	2CH
MARKER		EQU	2DH
TRIGH		EQU	2EH
PEAKH		EQU	2FH
TRIGL		EQU	30H
PEAKL		EQU	31H
TEMP		EQU	32H

			ORG     00               
			GOTO    SETUP

;------ MIDI NOTE DATA TABLE ----------

NOTE_TABLE 	ADDWF PCL,F
		
		DT	47,47,46,46,46,46,46,46,46,45
		DT	45,45,45,45,45,45,45,45,45,44
		DT	44,44,44,44,44,44,44,44,43,43
		DT	43,43,43,43,43,43,43,43,42,42
		DT	42,42,42,42,42,42,42,41,41,41
		DT	41,41,41,41,41,41,40,40,40,40
		DT	40,40,40,40,40,40,40,40,40,39
		DT	39,39,39,39,39,39,39,39,39,39
		DT	38,38,38,38,38,38,38,38,38,38
		DT	38,38,37,37,37,37,37,37,37,37
		DT	37,37,37,37,37,37,36,36,36,36
		DT	36,36,36,36,36,36,36,35,35,35
		DT	35,35,35,35,35,35,35,35,35,35					


;-------------------- SETUP -------------------------
    
SETUP    	PAGE0
        	CLRF    PORTA
        	CLRF    PORTB
        
			PAGE1
	  		MOVLW 	B'11111111'		
	  		MOVWF	OPTION_REG 		
 	 		PAGE0

	  		CLRF	PORTB
  
        	PAGE1
			MOVLW	B'01101010'
			MOVWF	OSCCON			;INTERNAL OSC SET TO 4MHZ
        	CLRF 	TRISB          	;ALL OUTPUTS
        
        	MOVLW 	B'11111111'
        	MOVWF 	TRISA			;ALL INPUTS
			MOVLW	7
			MOVWF	CMCON
			MOVLW	B'00011111'
			MOVWF	ANSEL
           
        	MOVLW	B'00110000'
			MOVWF 	ADCON1
        	PAGE0

			MOVLW 	B'01100001' 	;ADC CHANNEL 2
    		MOVWF 	ADCON0
   
;SET UP USART
   
			PAGE1
			MOVLW   1             	;31250 BAUD FOR MIDI
			MOVWF   SPBRG
			MOVLW   B'00100000'     ;ASYNC TX 8 BIT
			MOVWF   TXSTA
			PAGE0
			MOVLW   B'10010000'     ;ASYNC RX 8 BIT
			MOVWF   RCSTA
	              
			MOVLW 	B'00010001'		;SET TIMER1 ON AT PRESCALE=2
			MOVWF 	T1CON
	
			CLRF	MARKER
			BSF		MARKER,0		;AMPLITUDE DETECTION ACTIVE
		
			BSF		PORTB,1			;BOTH LEDS ON
			BSF		PORTB,3

			MOVLW	25
			MOVWF	DELAY3
W1			CALL 	PEAKS			;JUST A DELAY WHILE THE ELECTROLYTICS CHARGE UP
			DECFSZ	DELAY3,F
			GOTO	W1
			BCF		PORTB,1			;BOTH LEDS OFF AGAIN
			BCF		PORTB,3
			GOTO	MAIN

;---------- OUTPUT MIDI 'NOTE ON' ----------
  
NOTEON  
			MOVLW	090H			;NOTE-ON CH.1
        	MOVWF   TXREG   
        	CALL    TX
   
        	MOVF    NOTE,W
        	MOVWF   TXREG   
        	CALL    TX
  
			MOVF 	VELOCITY,W
        	MOVWF   TXREG   
        	CALL    TX
        	RETURN

;---------- OUTPUT MIDI 'NOTE OFF' ----------

NOTEOFF 
			MOVLW   080H			;NOTE-OFF CH.1
        	MOVWF   TXREG   
        	CALL    TX
   
        	MOVF    NOTE,W
        	MOVWF   TXREG   
        	CALL    TX

			MOVLW 	0				;VEL_OFF,W
        	MOVWF   TXREG   
        	CALL    TX
        	RETURN

;------------ TX COMPLETE ROUTINE -------------

TX			BSF		PORTB,3			;MIDI LED ON
			PAGE1
TX1			BTFSS	TXSTA,1   		;TX ENDED?
			GOTO	TX1				;NO SO REPEAT
			PAGE0					;YES
		
			RETURN

;------------ START ADC -----------------------
   
ADC 		BSF		ADCON0,2		;SET GO BIT
NOTYET	 	BTFSC	ADCON0,2		;CONVERSION COMPLETED?		
			GOTO	NOTYET			;NO
			RETURN					;YES


;----- VELOCITY AND TRIGGER CALCULATIONS ----------

TRIGVEL	
			CALL	PEAKS

			MOVF	PEAKL,W
			SUBWF	PEAKH,W
			MOVWF	MIDLINE
			MOVWF	VELOCITY				
			BCF		STATUS,C
			RRF		MIDLINE,W
			ADDWF	PEAKL,W
			MOVWF	MIDLINE
	
			MOVF	MIDLINE,W
			MOVWF	TRIGL
			MOVWF	TEMP
			MOVF	PEAKL,W
			SUBWF	TRIGL,F
			BCF		STATUS,C
			RRF		TRIGL,W
			SUBWF	TEMP,W
			MOVWF	TRIGL

			MOVF	MIDLINE,W
			SUBWF	PEAKH,W
			MOVWF	TRIGH
			BCF		STATUS,C
			RRF		TRIGH,W
			ADDWF	MIDLINE,W
			MOVWF	TRIGH

			RETURN

;--- WAVEFORM PEAK LEVEL DETECTION FOR 12MS ---

PEAKS	
			CLRF	PEAKH
			MOVLW	255
			MOVWF	PEAKL
			MOVLW	2
			MOVWF	DELAY1
CL2			MOVLW	200
			MOVWF	DELAY2
CL1			CALL 	ADC
			MOVF	ADRESH,W
			SUBWF	PEAKH,W
			BTFSS	STATUS,C
			CALL	UPDATE_PEAKH

			MOVF	PEAKL,W
			SUBWF	ADRESH,W
			BTFSS	STATUS,C
			CALL	UPDATE_PEAKL

			DECFSZ	DELAY2,F
			GOTO	CL1
			DECFSZ	DELAY1,F
			GOTO	CL2
			RETURN

UPDATE_PEAKH
			MOVF	ADRESH,W
			MOVWF	PEAKH
			RETURN

UPDATE_PEAKL
			MOVF	ADRESH,W
			MOVWF	PEAKL
			RETURN


;----- GET MIDI NOTE FROM FREQUENCY TIMING ----------

MIDINOTE  	BCF		MARKER,1
			MOVLW	48
			MOVWF 	OCTAVE
OCT			BCF 	STATUS,C
			RRF 	LOBYTE,F
			BCF 	STATUS,C
			RRF 	HIBYTE,F
			BTFSC 	STATUS,C
			BSF 	LOBYTE,7
			MOVF 	HIBYTE,F
			BTFSC 	STATUS,Z			;IS HIBYTE ZERO YET?
			GOTO 	MN2					;YES
			MOVLW	12					;NO
			SUBWF	OCTAVE,F
			BTFSC	STATUS,C			;IS OCTAVE BELOW ZERO, IE NEGATIVE
			GOTO	OCT					;NO	
			BSF		MARKER,1			;YES, SO SET MARKER,1 TO INDICATE ERROR
			RETURN

MN2			BCF		MARKER,2
			MOVLW	128					;SHIFT THE TABLE DOWN TO SAVE SPACE
			SUBWF	LOBYTE,F
			BTFSS	STATUS,C			;WAS NOTE BELOW 128
			GOTO	OUT_OF_RANGE

			MOVLW	130					;CHECK IF NOTE IS OUT OF RANGE IE ABOVE 130 ON THE TABLE
			SUBWF	LOBYTE,W
			BTFSC	STATUS,C		
			GOTO	OUT_OF_RANGE
			MOVF	LOBYTE,W
			CALL	NOTE_TABLE			;GET MIDI NOTE VALUE
			ADDWF	OCTAVE,W			;ADD THE OCTAVE VALUE
			RETURN

OUT_OF_RANGE
			BSF		MARKER,2
			RETURN		





;---- MEASURE TIME FOR ONE WAVE, BETWEEN PEAKS -------
  

TIMING		CLRF	TMR1L
			CLRF	TMR1H
			
T1			BTFSC	TMR1H,5
			GOTO	TERROR
			BCF		MARKER,3
			CALL	ADC
			MOVF	TRIGL,W
			SUBWF	ADRESH,W
			BTFSC	STATUS,C			;IS ADRESH - TRIGL +VE IE CARRY SET?
			GOTO	T1					;NO, SO RETEST UNTIL IT IS

T2			BTFSC	TMR1H,5
			GOTO	TERROR
			CALL	ADC
			MOVF	ADRESH,W
			SUBWF	TRIGH,W
			BTFSC	STATUS,C			;IS ADRESH - TRIGH +VE IE CARRY SET?
			GOTO	T2					;NO, SO RETEST UNTIL IT IS
	
			CLRF 	TMR1L
			CLRF 	TMR1H
			NOP
		
T3			BTFSC	TMR1H,5
			GOTO	TERROR
			CALL	ADC
			MOVF	TRIGL,W
			SUBWF	ADRESH,W
			BTFSC	STATUS,C			;IS ADRESH - TRIGL +VE IE CARRY SET?
			GOTO	T3					;YES, SO RETEST UNTIL IT IS

T4			BTFSC	TMR1H,5
			GOTO	TERROR
			CALL	ADC
			MOVF	ADRESH,W
			SUBWF	TRIGH,W
			BTFSC	STATUS,C			;IS ADRESH - TRIGH +VE IE CARRY SET?
			GOTO	T4					;NO, SO RETEST UNTIL IT IS
		
			BCF		T1CON,0				;STOP THE TIMER TO RETRIEVE THE DATA
		
			MOVF 	TMR1L,W
			MOVWF 	LOBYTE

			MOVF 	TMR1H,W
			MOVWF 	HIBYTE

			BSF		T1CON,0				;RESTART THE TIMER
			RETURN

TERROR
			BSF		MARKER,3
			RETURN




;------ MAIN PROGRAM -------------------------------------------------------
    
MAIN  		CALL 	TRIGVEL
			MOVF	VELOCITY,W
			MOVWF	OLD
			BTFSS	MARKER,0			;IS AMPLITUDE DETECTION ACTIVE?
			GOTO	L0					;NO
			BCF		PORTB,3				;YES, MIDI LED OFF
			MOVLW	10
			SUBWF	VELOCITY,W
          	BTFSS	STATUS,C 			;SKIP IF VELOCITY>10 IE CARRY SET
	   		GOTO	MAIN
	
L0			BCF		PORTB,1				;TURN CLIP LED OFF
			BCF		PORTB,3				;MIDI LED OFF
	
L1			CALL 	TIMING 
			BTFSC	MARKER,3			;DID THE WAVE TIMER TIME-OUT?
			GOTO	MAIN				;YES, SO START AGAIN
			CALL 	MIDINOTE			;NO
			BTFSC	MARKER,2			;WAS THE NOTE OUT OF RANGE?
			GOTO	L1					;YES SO TRY AGAIN
			MOVWF 	NOTE				

;--------- INCREASE VELOCITY BY 60 AND LIMIT TO 127 --------------

			MOVLW	194
			MOVWF	TEMP
			MOVF	VELOCITY,W
			SUBWF	TEMP,W
			BTFSS	STATUS,C
			GOTO	HERE
		
			MOVF	VELOCITY,W
			ADDLW	60
			MOVWF	VELOCITY
			MOVLW	126
			MOVWF	TEMP
			MOVF	VELOCITY,W
			SUBWF	TEMP,W
			BTFSS	STATUS,C
HERE
			CALL	VEL_LIMIT

;------------------------------------------------------------------

			CALL NOTEON					;SENDS INITIAL MIDI NOTE AND VELOCITY VALUES
		
NOTE_OFF   	
			CALL	TRIGVEL
			MOVF	VELOCITY,W
			MOVWF 	TEMP
			MOVWF	NEW
		
			BCF		PORTB,3				;MIDI LED OFF
			BCF		PORTB,1				;CLIP LED OFF
			BSF		MARKER,0			;AMPLITUDE DETECTION ACTIVE
          
			MOVLW	3					;NOTE OFF THRESHOLD VALUE
           	SUBWF 	NEW,W		
           	BTFSS 	STATUS,C 			;IS VELOCITY ABOVE THRESHOLD?
           	GOTO	NEXT      			;NO, SO NOTE HAS ENEDED
			BCF		MARKER,0			;YES, SO KEEP TESTING. AMP ON DETECTION TURNED OFF	

			MOVLW	10					;X VALUE
			ADDWF	OLD,W
			BTFSC	STATUS,C			;IS X+OLD>255
			MOVLW	255					;YES SO MAKE IT 255
			SUBWF	NEW,W
			BTFSC	STATUS,C			;IS NEW VALUE 'X' ABOVE OLD, IE PLUCK HAS OCCURED
			GOTO	NEXT2				;YES SO PROCESS NOTE OFF AND NEW NOTE ON
	
			MOVF	NEW,W				;NO SO UPDATE 'OLD' WITH NEW LOWER VALUE
			MOVWF	OLD			
	   		GOTO 	NOTE_OFF			;KEEP READING ADC		

;-------------------------------------------------------------------------------------

NEXT		CALL 	NOTEOFF				;TURN OFF EXISTING MIDI NOTE
			GOTO 	MAIN  				;GET READY FOR NEW NOTE

NEXT2		CALL	NOTEOFF				;TURN OFF EXISTING MIDI NOTE
			MOVF	NEW,W
			MOVWF	OLD
			GOTO	L0    				;BYPASS AMPLITUDE DETECTION    
    
VEL_LIMIT	BSF		PORTB,1				;TURN ON CLIP LED
			MOVLW	127
			MOVWF	VELOCITY
			RETURN


             END
    

